<?php

use App\Lib\Router;
use Illuminate\Support\Facades\Route;

Route::get('/clear', function(){
    \Illuminate\Support\Facades\Artisan::call('optimize:clear');
});

// User Support Ticket
Route::controller('TicketController')->prefix('ticket')->group(function () {
    Route::get('/', 'supportTicket')->name('ticket');
    Route::get('/new', 'openSupportTicket')->name('ticket.open');
    Route::post('/create', 'storeSupportTicket')->name('ticket.store');
    Route::get('/view/{ticket}', 'viewTicket')->name('ticket.view');
    Route::post('/reply/{ticket}', 'replyTicket')->name('ticket.reply');
    Route::post('/close/{ticket}', 'closeTicket')->name('ticket.close');
    Route::get('/download/{ticket}', 'ticketDownload')->name('ticket.download');
});

  // Payment
  Route::controller('Gateway\PaymentController')->group(function(){
    Route::get('payment/{id}', 'payment')->name('payment');
    Route::any('/product/payment', 'productPayment')->name('product.payment');
    Route::post('deposit/insert', 'depositInsert')->name('deposit.insert');
    Route::get('deposit/confirm', 'depositConfirm')->name('deposit.confirm');
    Route::get('deposit/manual', 'manualDepositConfirm')->name('deposit.manual.confirm');
    Route::post('deposit/manual', 'manualDepositUpdate')->name('deposit.manual.update');
});

Route::get('app/deposit/confirm/{hash}', 'Gateway\PaymentController@appDepositConfirm')->name('deposit.app.confirm');

Route::controller('SiteController')->group(function () {
    Route::get('/contact', 'contact')->name('contact');
    Route::post('/contact', 'contactSubmit');
    Route::get('/change/{lang?}', 'changeLanguage')->name('lang');

    Route::get('cookie-policy', 'cookiePolicy')->name('cookie.policy');

    Route::get('/cookie/accept', 'cookieAccept')->name('cookie.accept');
    // blog
    Route::get('/blog','blog');
    Route::get('blog/{slug}/{id}', 'blogDetails')->name('blog.details');

    Route::get('policy/{slug}/{id}', 'policyPages')->name('policy.pages');

    Route::get('placeholder-image/{size}', 'placeholderImage')->name('placeholder.image');
     // subscriber
     Route::post('/subscribe','subscribe')->name('subscribe');

    // plan
    Route::get('/plan','plan')->name('plans');

     // addToCart
     Route::get('/cart/add/', 'addToCart')->name('cart.add');
    // cart page
    Route::get('/cart','getCart')->name('get.cart');
    // update cart
    Route::get('/update/quantity', 'updateQuantity');
    // remove cart item
    Route::get('/remove/cart/item', 'removeCartItem');
    // modal into get product information
    Route::get('/get/product/info', 'getModalProductInfo')->name('getmodal.info');
    // product details
    Route::get('product/{slug}/{id}', 'productDetails')->name('product.details');
    // add to wishlist
    Route::get('/wishlist/add', 'addToWishList')->name('wishlist.add');
    // shop page
    Route::get('/shop','shop')->name('shop');
    // ref url check subscribe
    Route::get('/check-subscription/{userId}', 'checkSubscription');
    // checkout
    Route::get('/checkout','getChectout')->name('get.checkout');

     // coupon apply
     Route::post('/coupon','applyCoupon')->name('apply.coupon');

    //  search product
    Route::get('/product/search', 'productSearch')->name('product.search');

    // filter category and brand product
    Route::get('/category-product/{id}', 'filterCategoryProducts')->name('filter.category.products');
    Route::get('/brand-product/{id}', 'filterBrandProducts')->name('filter.brand.products');










    Route::get('/{slug}', 'pages')->name('pages');
    Route::get('/', 'index')->name('home');
});


