@extends($activeTemplate.'layouts.master')
@section('content')

<!-- ==================== Card Start Here ==================== -->
<div class="col-xl-9 col-lg-12">
    <div class="dashboard-body account-form">
        <div class="dashboard-body__bar">
            <span class="dashboard-body__bar-icon"><i class="las la-bars"></i></span>
        </div>
        <div class="row gy-4 justify-content-center">
            <h4>{{__($pageTitle)}}</h4>
                <div class="card-wrap">
                    <table class="table table--responsive--lg">
                        <thead>
                            <tr>
                                <th>@lang('Product Name')</th>
                                <th>@lang('User')</th>
                                <th>@lang('Commission')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($refCommissions as $item)
                            <tr>
                                <td data-label="Product Name">{{ $item->product_name }}</td>
                                <td data-label="User">
                                    @if($item->user_name == "")
                                    @lang('guest user')
                                    @else
                                    {{ $item->user_name }}
                                    @endif
                                </td>
                                <td data-label="Commission" class="fw-bold">{{__($general->cur_sym)}} {{ showAmount($item->ref_amount) }}</td>
                            </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="3" data-label="Refferal Table">{{ __($emptyMessage) }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

            @if ($refCommissions->hasPages())
            <div class="d-flex justify-content-end">
                {{ paginateLinks($refCommissions) }}
            </div>
            @endif
        </div>
    </div>
</section>
<!-- ==================== Card End Here ==================== -->
@endsection

