@extends($activeTemplate.'layouts.master')
@section('content')
@php
if($subscribe){
    $start = Carbon\Carbon::parse($subscribe->starts_at);
    $end = Carbon\Carbon::parse($subscribe->ends_at);
    $durationInDays = $end->diffInDays($start);
    $duration = $end->diffForHumans($start);
}
@endphp
    <div class="col-xl-9 col-lg-12">
                <div class="dashboard-body">
                    <div class="dashboard-body__bar">
                        <span class="dashboard-body__bar-icon"><i class="las la-bars"></i></span>
                    </div>
                    <div class="row gy-4 justify-content-center">
                        @if($subscribe)
                        <div class="col-xl-4 col-lg-6 col-sm-6">
                            <div class="dashboard-card">
                                <span class="banner-effect-1"></span>
                                <div class="dashboard-card__icon">
                                    <i class="fas fa-gift"></i>
                                </div>
                                <div class="dashboard-card__content">
                                    <h5 class="dashboard-card__title">{{__($subscribe->plan->name)}}</h5>
                                    <h4 class="dashboard-card__amount">{{__($general->cur_sym)}} {{showAmount($subscribe->plan->price)}}</h4>
                                    <h4 class="dashboard-card__amount mt-2">@lang('Expired'): <span id="expired-in"></span></h4>
                                </div>
                            </div>
                        </div>
                        @elseif($subscribe === false)
                        <div class="col-xl-4 col-lg-6 col-sm-6">
                          <a class="d-block" href="{{route('plans')}}">
                            <div class="dashboard-card">
                                <span class="banner-effect-1"></span>
                                <div class="dashboard-card__icon">
                                    <i class="fas fa-gift"></i>
                                </div>
                                <div class="dashboard-card__content">
                                    <h5 class="dashboard-card__title">@lang('Current Plan Expired')</h5>
                                    <h4 class="dashboard-card__amount">@lang('subscribe to a new plan')</h4>
                                </div>
                            </div>
                          </a>
                        </div>
                        @elseif($subscribe === null)
                        <div class="col-xl-4 col-lg-6 col-sm-6">
                            <a class="d-block" href="{{route('plans')}}">
                              <div class="dashboard-card">
                                  <span class="banner-effect-1"></span>
                                  <div class="dashboard-card__icon">
                                    <i class="fas fa-gift"></i>
                                  </div>
                                  <div class="dashboard-card__content">
                                      <h5 class="dashboard-card__title">@lang('No Plan')</h5>
                                      <h4 class="dashboard-card__amount">@lang('subscribe to a new plan')</h4>
                                  </div>
                              </div>
                            </a>
                          </div>
                        @endif

                        <div class="col-xl-4 col-lg-6 col-sm-6">
                            <a class="d-block" href="{{route('user.orders')}}">
                                <div class="dashboard-card">
                                    <span class="banner-effect-1"></span>
                                    <div class="dashboard-card__icon">
                                        <i class="fas fa-cart-plus"></i>
                                    </div>
                                    <div class="dashboard-card__content">
                                        <h5 class="dashboard-card__title">@lang('My Orders')</h5>
                                        <h4 class="dashboard-card__amount">{{__($ordersCount)}}</h4>
                                    </div>
                                </div>
                            </a>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-sm-6">
                            <a class="d-block" href="{{route('user.get.wishlist')}}">
                                <div class="dashboard-card">
                                    <span class="banner-effect-1"></span>
                                    <div class="dashboard-card__icon">
                                        <i class="fas fa-heart"></i>
                                    </div>
                                    <div class="dashboard-card__content">
                                        <h5 class="dashboard-card__title">@lang('My Wishlist')</h5>
                                        <h4 class="dashboard-card__amount">{{__($wishlistCount)}}</h4>
                                    </div>
                                </div>
                            </a>
                        </div>

                        <div class="col-xl-4 col-lg-6 col-sm-6">
                            <a class="d-block" href="{{route('plans')}}">
                                <div class="dashboard-card">
                                    <span class="banner-effect-1"></span>
                                    <div class="dashboard-card__icon">
                                        <i class="fas fa-gift"></i>
                                    </div>
                                    <div class="dashboard-card__content">
                                        <h5 class="dashboard-card__title">@lang('All Plans')</h5>
                                        <h4 class="dashboard-card__amount">@lang('all plans')</h4>
                                    </div>
                                </div>
                            </a>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-sm-6">
                            <div class="dashboard-card">
                                <span class="banner-effect-1"></span>
                                <div class="dashboard-card__icon">
                                    <i class="fas fa-hand-holding-usd"></i>
                                </div>
                                <div class="dashboard-card__content">
                                    <h5 class="dashboard-card__title">@lang('Balance')</h5>
                                    <h4 class="dashboard-card__amount">{{__($general->cur_sym)}} {{showAmount($userBalace)}}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-sm-6">
                            <a class="d-block" href="{{route('user.getrefferal')}}">
                                <div class="dashboard-card">
                                    <span class="banner-effect-1"></span>
                                    <div class="dashboard-card__icon">
                                        <i class="fas fa-dollar-sign"></i>
                                    </div>
                                    <div class="dashboard-card__content">
                                        <h5 class="dashboard-card__title">@lang('Affiliate Commision')</h5>
                                        <h4 class="dashboard-card__amount">{{__($general->cur_sym)}} {{showAmount($refferalAmount)}}</h4>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
@endsection

@push('script')
<script>
    $(document).ready(function() {
        var end = moment('{{ @$subscribe->ends_at }}');
        var now = moment();

        function updateExpiredIn() {
            var duration = moment.duration(end.diff(now));
            var days = Math.floor(duration.asDays());
            var hours = Math.floor(duration.asHours()) - days * 24;
            var minutes = Math.floor(duration.asMinutes()) - days * 24 * 60 - hours * 60;
            var seconds = Math.floor(duration.asSeconds()) - days * 24 * 60 * 60 - hours * 60 * 60 - minutes * 60;

            var expiredIn = days + ' days ' + hours + ' hours ' + minutes + ' minutes ' + seconds + ' seconds';
            $('#expired-in').text(expiredIn);
        }

        // update the expired time every second
        setInterval(function() {
            now = moment();
            updateExpiredIn();
        }, 1000);

        // initial update
        updateExpiredIn();
    });
</script>
@endpush
