@php
$featuredProduct = getContent('featured.content', true);
$product = App\Models\Product::where('is_featured', 1)->with('productImages')->first();
@endphp
@if($product)
<div class="about-section py-80 ">
    <img class="about-bg" src="{{asset($activeTemplateTrue.'images/dotted-shape.png')}}" alt="shape">
    <div class="container">
        <div class="row gy-4 align-items-center flex-wrap-reverse">
            <div class="col-lg-6 position-relative">
                <div class="about-thumb">
                    <div class="about-thumb__inner">
                        <img class="img-2" src="{{ getImage(getFilePath('product').'/'.@$product->productImages[0]->image)}}" alt="image">
                    </div>
                </div>
            </div>

            <div class="col-lg-6 position-relative">
                <div class="about-right-content">
                     <div class="section-heading mb-0">
                        <span class="subtitle">{{__($featuredProduct->data_values->top_heading) }}</span>
                        <h2 class="section-heading__title">
                            {{__($product->name) }}
                        </h2>
                        <p class="section-heading__title price">{{__($general->cur_sym)}} {{showAmount($product->price) }}</p>
                        <p class="section-heading__desc mb-4">
                            @if(strlen(__($product->short_desc)) >700)
                            {{substr( __($product->short_desc), 0,700).'...' }}
                            @else
                            {{__($product->short_desc)}}
                            @endif
                        </p>

                        <div class="about-bottom">
                        <a href="{{ route('product.details', ['slug' => slug($product->name), 'id' => $product->id])}}" class="btn btn--base me-3 mb-2">
                           @lang(' Buy Now ') <i class="fas fa-arrow-right"></i>
                        </a>
                        </div>
                     </div>
                </div>
            </div>

        </div>
    </div>
</div>
@endif
