@php
$faq = getContent('faq.content', true);
$faqElements = getContent('faq.element', false,12);
@endphp
<!-- ==================== Accordion Start Here ==================== -->
<section class="accordion-area py-80 " >
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="section-heading  text-center">
                    <span class="subtitle">{{ __($faq->data_values->top_heading) }}</span>
                    <h2 class="section-heading__title ">
                        {{ __($faq->data_values->heading) }}
                    </h2>
                    <p class="section-heading__desc">{{ __($faq->data_values->sub_heading) }}</p>
                </div>
            </div>
        </div>
        <div class="row gy-4 align-items-center">
            <div class="col-lg-6">
                <div class="accordion custom--accordion" id="accordionExample">
                    {{-- Display even indices first --}}
                    @foreach($faqElements as $index => $item)
                        @if($index % 2 == 0)
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="heading{{ $index }}">
                                    <button class="accordion-button {{ $index == 0 ? '' : 'collapsed' }}" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{ $index }}" aria-expanded="{{ $index == 0 ? 'true' : 'false' }}">
                                        {{ __($item->data_values->question) }}
                                    </button>
                                </h2>
                                <div id="collapse{{ $index }}" class="accordion-collapse collapse {{ $index == 0 ? 'show' : '' }}" aria-labelledby="heading{{ $index }}" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        {{ strLimit(strip_tags($item->data_values->answer), 350) }}
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
            <div class="col-lg-6">
                <div class="accordion custom--accordion" id="accordionExample2">
                    {{-- Display odd indices next --}}
                    @foreach($faqElements as $index => $item)
                        @if($index % 2 != 0)
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="heading{{ $index }}">
                                    <button class="accordion-button {{ $index == 1 ? '' : 'collapsed' }}" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{ $index }}" aria-expanded="{{ $index == 1 ? 'true' : 'false' }}">
                                        {{ __($item->data_values->question) }}
                                    </button>
                                </h2>
                                <div id="collapse{{ $index }}" class="accordion-collapse collapse {{ $index == 1 ? 'show' : '' }}" aria-labelledby="heading{{ $index }}" data-bs-parent="#accordionExample2">
                                    <div class="accordion-body">
                                        {{ strLimit(strip_tags($item->data_values->answer), 350) }}
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>

    </div>
</section>
<!-- ==================== Accordion End Here ==================== -->
