@extends($activeTemplate.'layouts.frontend')
@section('content')
@php
$bannerElements = getContent('banner.element', false);
$subscribe = getContent('subscribe.content',true);
@endphp
<!--========================== Banner Section Start ==========================-->
<!-- bg-img -->
<section class="banner-section wow fadeInUp " data-wow-delay="00ms" data-wow-duration="2000ms" style="visibility: visible; animation-duration: 2000ms; animation-delay: 0ms; animation-name: fadeInUp;">
    <span class="banner-effect-1"></span>
    <div class="slider-active">
        @foreach($bannerElements as $item)
        <div class="single-slider" data-animation="fadeInUp" data-delay=".2s" >
            <div class="container">
                <div class="row gy-4 align-items-center">
                    <div class="col-lg-6">
                          <div class="banner-left__content">
                                <span data-animation="fadeInUp" data-delay=".3s" class="subtitle">{{__($item->data_values->top_heading)}}</span>
                                <h2 data-animation="fadeInUp" data-delay=".4s">{{__($item->data_values->heading)}}</h2>
                                <p data-animation="fadeInUp" data-delay=".5s">{{__($item->data_values->sub_heading)}}</p>

                              <div class="banner-bottom d-flex align-items-center" data-animation="fadeInUp" data-delay=".6s">
                                <a href="{{route('shop')}}" class="btn btn--base me-4 mb-2">
                                    {{__($item->data_values->banner_btn)}} <i class="fas fa-arrow-right"></i>
                                  </a>
                                  <div class="popup-vide-wrap">
                                    <div class="video-main">
                                        <div class="promo-video">
                                            <div class="waves-block">
                                                <div class="waves wave-1"></div>
                                                <div class="waves wave-2"></div>
                                                <div class="waves wave-3"></div>
                                            </div>
                                        </div>
                                        <a class="play-video popup_video" data-fancybox="" href="{{__($item->data_values->banner_link)}}">
                                            <span class="play-btn"> <i class="fa fa-play"></i></span>
                                        </a>
                                    </div>
                                </div>
                              </div>

                          </div>
                      </div>
                    <div class="col-lg-6">
                      <div class="banner-right-wrap position-relative">
                        <div class="banner-thumb" data-animation="fadeInUp" data-delay=".5s">
                          <img class="experience-text " src="{{getImage(getFilePath('banner').'/'.$item->data_values->banner_image)}}" alt="banner-image">
                        </div>
                      </div>
                    </div>
                </div>
            </div>
        </div>
        @endforeach
    </div>
</section>
<!--========================== Banner Section End ==========================-->

<!-- ==================== New Letter Start Here ==================== -->
<div class="newsletter-popup-wrap" data-animation="slideInUp">
    <div class="newsletter-popup-wrap__inner">
        <button class="newsletter-popup-wrap__close-btn" aria-label="search close button">
            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 512 512"><path fill="currentColor" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M368 368L144 144M368 144L144 368"></path></svg>
        </button>
        <div class="box newsletter-popup-wrap__box d-flex align-items-center">
            <div class="newsletter-popup-wrap__thumbnail">
                <img class="newsletter-popup-wrap__thumbnail-img display-block" src="{{getImage(getFilePath('subscribe').'/'.$subscribe->data_values->subscribe_img)}}" alt="newsletter-popup-thumb">
            </div>
            <div class="newsletter-popup-wrap__box-right">
                <h2 class="section-heading__title">{{__($subscribe->data_values->top_heading)}}</h2>

                <div class="newsletter-popup-wrap__content">
                    <p class="newsletter-popup-wrap__content-desc">{{__($subscribe->data_values->heading)}}</p>
                    <div class="newsletter-popup-wrap__subscribe" id="frm_subscribe">
                        <form action="{{route('subscribe')}}" method="POST">
                            @csrf
                            <div class="row gy-3">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" class="form--control" name="email" id="email" placeholder="@lang('Email Address')">
                                    </div>
                                </div>
                                <div class="col-sm-12 mb-3">
                                    <button type="submit" class="btn btn--base w-100">
                                       @lang('Subscribe') <i class="fas fa-arrow-right"></i>
                                        <span style="top: -3px; left: 130px;"></span>
                                    </button>
                                </div>
                            </div>
                        </form>
                        <div class="col-sm-12">
                            <div class="d-flex flex-wrap justify-content-between">
                                <div class="form--check">
                                    <input class="form-check-input" type="checkbox" value="" id="newsletter-dont--show">
                                    <label class="form-check-label" for="newsletter-dont--show">@lang('Don\'t show this popup again me') </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- ==================== New Letter End Here ==================== -->

@if($sections->secs != null)
@foreach(json_decode($sections->secs) as $sec)
@include($activeTemplate.'sections.'.$sec)
@endforeach
@endif
@endsection

