@extends('admin.layouts.app')
@section('panel')
<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two custom-data-table">
                        <thead>
                            <tr>
                                <th>@lang('Name')</th>
                                <th>@lang('Image')</th>
                                <th>@lang('status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody id="brandTable">
                           @forelse ($brands as $item)
                           <tr data-id="{{ $item->id }}">
                              <td>{{__($item->name)}}</td>
                              <td>
                                <img src="{{ getImage(getFilePath('brand').'/'.@$item->image)}}" alt="Image" class="rounded brand-image" style="width:50px;">
                              </td>
                              <td>
                                @php
                                    echo $item->statusBadge($item->status);
                                @endphp
                            </td>
                              <td>
                                 <div class="button--group">
                                    <button type="button" class="btn btn-sm btn--primary updateBrand"data-id="{{$item->id}}"data-name="{{$item->name}}" data-status="{{$item->status}}"><i class="las la-edit"></i></button>
                                 </div>
                              </td>
                           </tr>
                           @empty
                           <tr class="empty-message">
                             <td class="text-muted text-center" colspan="100%">{{__($emptyMessage) }}</td>
                          </tr>
                           @endforelse
                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            @if ($brands->hasPages())
            <div class="card-footer py-4">
                {{ paginateLinks($brands) }}
            </div>
            @endif
        </div><!-- card end -->
    </div>
</div>


{{-- Add METHOD MODAL --}}
<div id="addBrand" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"> @lang('Add Brand')</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form id="brandForm" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label for="name">@lang('Name'):</label>
                        <input type="text" class="form-control" name="name" placeholder="@lang('Name')..." required>
                    </div>
                    <div class="form-group">
                        <label for="name">@lang('Image'):</label>
                        <input type="file" class="form-control" name="image" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary btn-global">@lang('Submit')</button>
                </div>
            </form>
        </div>
    </div>
</div>


{{-- Update METHOD MODAL --}}
<div id="updateBrand" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"> @lang('Update Manage Category')</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form id="updateBrandForm" method="POST" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="id">
                <div class="modal-body">
                    <div class="form-group">
                        <label  for="name"> @lang('Name'):</label>
                        <input type="text" class="form-control" name="name" placeholder="@lang('Name')...">
                    </div>
                    <div class="form-group">
                        <label for="name">@lang('Image'):</label>
                        <input type="file" class="form-control" name="image">
                    </div>
                    <div class="form-group">
                        <label  for="name"> @lang('Status'):</label>
                        <select name="status" class="form-control">
                            <option value="0" {{ @$item->status == 0 ? 'selected' : '' }}>@lang('Inactive')</option>
                            <option value="1" {{ @$item->status == 1 ? 'selected' : '' }}>@lang('Active')</option>
                        </select>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary btn-global">@lang('Save')</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@push('breadcrumb-plugins')
<button type="button" class="btn btn-sm btn--primary addBrand"><i class="las la-plus"></i>@lang('Add
    New')</button>
@endpush
@push('script')
<script>
     "use strict";
    //  add category  modal show
    (function($){
        $('.addBrand').on('click', function() {
        $('#addBrand').modal('show');
    });

    // update modal anad existing data show
    $('.updateBrand').on('click', function() {
        var modal = $('#updateBrand');
        modal.find('input[name=id]').val($(this).data('id'));
        modal.find('input[name=name]').val($(this).data('name'));

        var statusValue = $(this).data('status');
        modal.find('select[name=status]').val(statusValue);

        modal.modal('show');
    });
    })(jQuery);


    // add brand
    $(document).ready(function() {
        // add form
        $('#brandForm').submit(function(e) {
            e.preventDefault();
            var formData = new FormData(this);

            $.ajax({
                url: '{{ route("admin.brand.store") }}',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {

                if (response.hasOwnProperty('message')) {
                        Toast.fire({
                                    icon: 'success',
                                    title: response.message
                                });
                    }
                    $('#brandForm')[0].reset();
                    $('#addBrand').modal('hide');
                    appendBrand(response.brand,);

                    if ($('#brandTable tr').length > 1) {
                    $('#brandTable tr.empty-message').hide();
            }
                },
                error: function(xhr, status, error) {

                    // If the response contains validation errors
                    if (xhr.status === 422 && xhr.responseJSON && xhr.responseJSON.errors) {
                        var errors = xhr.responseJSON.errors;

                        // Show specific error messages for each field
                        for (var field in errors) {
                            if (errors.hasOwnProperty(field)) {
                                var errorMessage = errors[field][0];
                                Toast.fire({
                                    icon: 'error',
                                    title: errorMessage
                                });
                            }
                        }
                    } else {
                        var errorMessage = 'brnad could not be created. Please try again later.';
                        Toast.fire({
                            icon: 'error',
                            title: errorMessage
                        });
                    }
                }
            });
        });

        // update category
        $('#updateBrandForm').submit(function(e) {
            e.preventDefault();

            var formData = new FormData(this);

            $.ajax({
                url: '{{ route("admin.brand.update") }}',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {

                if (response.hasOwnProperty('message')) {
                        Toast.fire({
                                    icon: 'success',
                                    title: response.message
                                });
                    }

                var branadId = response.brand.id;
                var brandName = response.brand.name;
                var brandStatus = response.brand.status;
                var imagePath = response.updateimageUrl;


                // Update category data in the table row
                var $tableRow = $('#brandTable').find('tr[data-id="' + branadId + '"]');
                if ($tableRow.length) {
                    $tableRow.find('td:nth-child(1)').text(brandName);
                    $tableRow.find('td .brand-image').attr('src', imagePath);
                    $tableRow.find('td:nth-child(3)').html(brandStatus === 1 ? '<span class="badge badge--success">Active</span>' : '<span class="badge badge--danger">Inactive</span>');
                }

                $(document).on('click', '.updateBrand', function() {
                 var modal = $('#updateBrand').modal('show');
                 modal.find('input[name=id]').val(branadId);
                 modal.find('input[name=name]').val(brandName);
                 var statusValue = brandStatus === 1 ? '1' : '0';
                modal.find('select[name=status]').val(statusValue);

                 });

                  $('#updateBrandForm').get(0).reset();
                  $('#updateBrand').modal('hide');
                },
                error: function(xhr, status, error) {

                    // If the response contains validation errors
                    if (xhr.status === 422 && xhr.responseJSON && xhr.responseJSON.errors) {
                        var errors = xhr.responseJSON.errors;

                        // Show specific error messages for each field
                        for (var field in errors) {
                            if (errors.hasOwnProperty(field)) {
                                var errorMessage = errors[field][0];
                                Toast.fire({
                                    icon: 'error',
                                    title: errorMessage
                                });
                            }
                        }
                    } else {
                        var errorMessage = 'Brand could not be updated. Please try again later.';
                        Toast.fire({
                            icon: 'error',
                            title: errorMessage
                        });
                    }
                }
            });
        });

        // apend new category
        function appendBrand(brand) {
            // get image url
            $.ajax({
                url: '{{ route("admin.brand.getimage") }}',
                type: 'get',
                data: { brandImage: brand.image },
                success: function(response) {
                $('tr:first-child td:nth-child(2) .rounded').attr('src', response.imageUrl);
                },
                error: function(error) {
                console.log(error);
                }
            });

            var statusLabel = brand.status === 1 ? 'Active' : 'Inactive';
            var statusBadge = brand.status === 1 ? '<span class="badge badge--success">Active</span>' : '<span class="badge badge--danger">Inactive</span>';
            var image = '<img src="" alt="Image" class="rounded" style="width:50px;">';

            var tableRow = '<tr>' +
                '<td>' + brand.name + '</td>' +
                '<td>' + image + '</td>' +
                '<td>' + statusBadge + '</td>' +
                '<td>' +
                '<div class="button--group">' +
                '<button type="button" class="btn btn-sm btn--primary updateBrand" data-id="' + brand.id + '" data-name="' + brand.name + '" data-status="' + brand.status + '"><i class="las la-edit"></i></button>' +
                '</div>' +
                '</td>' +
                '</tr>';

            $('#brandTable').prepend(tableRow);


            $(document).on('click', '.updateBrand', function() {

                var modal = $('#updateBrand').modal('show');
                    modal.find('input[name=id]').val($(this).data('id'));
                    modal.find('input[name=name]').val($(this).data('name'));
                    var statusValue = $(this).data('status');
                    modal.find('select[name=status]').val(statusValue);

                });
        }

    });

</script>

@endpush
