<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Brand;
use Illuminate\Http\Request;

class BrandController extends Controller
{
    public function index(){
        $pageTitle = 'All Brands';
        $brands = Brand::orderBy('id','desc')->paginate(getPaginate(12));
        return view('admin.brand.index',compact('brands','pageTitle'));
    }


     public function store(Request $request)
     {
             $request->validate([
                 'name' => 'required|max:191|unique:brands',
             ]);

             $brand = new Brand();
             $brand->name = $request->name;
             $brand->status = 1;

             if ($request->hasFile('image')) {
                try {
                    $brand->image = fileUploader($request->image, getFilePath('brand'),getFileSize('brand'));
                } catch (\Exception $exp) {
                    $notify[] = ['error', 'Couldn\'t upload your image'];
                    return back()->withNotify($notify);
                }
            }
             $brand->save();

             return response()->json([
                 'message' => 'brand has been created successfully',
                 'brand' => $brand,
             ]);

    }


     public function getImage(Request $request){
        $brandImage = $request->input('brandImage');
        $imageUrl = getImage(getFilePath('brand') . '/' . $brandImage);

        return response()->json(['imageUrl' => $imageUrl]);
     }

     public function update(Request $request)
     {
             $request->validate([
                 'name' => 'required',
             ]);

             $brand = Brand::findOrFail($request->id);
             $brand->name = $request->name;
             $brand->status = $request->status ? 1 : 0;

             if ($request->hasFile('image')) {
                try {
                    $old = $brand->image;
                    $brand->image = fileUploader($request->image, getFilePath('brand'),getFileSize('brand'), $old);
                } catch (\Exception $exp) {
                    $notify[] = ['error', 'Couldn\'t upload your image'];
                    return back()->withNotify($notify);
                }
            }
             $brand->save();
             $imageUrl = getImage(getFilePath('brand') . '/' . @$brand->image);

             return response()->json([
                 'message' => 'brand has been updated successfully',
                 'brand' => $brand,
                 'updateimageUrl' => $imageUrl,
             ]);

    }
}
